

/* Copyright 1988-1991 UserLand Software, Inc.  All Rights Reserved.*/


#include "landinternal.h"



pascal boolean landaddclass (tyverbclass class) {
	
	register hdllandglobals hg = landgetglobals ();	
	register boolean fl = true;
	
	(**hg).currentclass = class;
	
	if ((**hg).transport == macsystem7) {
		
		/*
		if (!landverbsupported (class, (tyverbtoken) 0))
		*/
			fl = landsystem7addclass (class);
		}
	
	return (fl);
	} /*landaddclass*/


static pascal boolean landaddverbtoken (tyverbtoken token, boolean flfasthandler) {
	
	/*
	push the token on the verbarray list.
	*/
	
	register hdllandglobals hg = landgetglobals ();	
	register hdlverbarray hverbs = (**hg).verbarray;
	tyverbarrayelement item;

	if (hverbs == nil) {
		
		hdlverbarray hnewarray;
		
		if (!landnewemptyhandle ((Handle *) &hnewarray))
			return (false);

		hverbs = hnewarray; /*copy into register*/
		
		(**hg).verbarray = hverbs;
		}
		
	item.class = (**hg).currentclass;
		
	item.token = token;
	
	item.flfasthandler = flfasthandler;
	
	if (!landenlargehandle ((Handle) hverbs, longsizeof (item), &item))
		return (false);
	
	if (!flfasthandler)
		return (true);
	
	return (landsystem7addfastverb (item.class, item.token));
	} /*landaddverbtoken*/


pascal boolean landaddverb (tyverbtoken token) {
	
	/*
	push the verb's token on the verbarray list.
	*/
	
	return (landaddverbtoken (token, false));
	} /*landaddverb*/


pascal boolean landaddfastverb (tyverbtoken token) {
	
	/*
	push the verb's token on the verbarray list and set it up to be invoked 
	as a fast handler
	*/
	
	return (landaddverbtoken (token, true));
	} /*landaddfastverb*/	




